﻿///
/// 文字列に対する処理関数を宣言するヘッダファイル。
///

#if       !defined(INCLUDED_SOFTGATE_BUFFERS)
#define            INCLUDED_SOFTGATE_BUFFERS

/// スタック上のバッファを自分のスコープの間だけ管理するバッファクラス。
template <typename T, u32 SIZE> class sbuf
{
private:
  T buf[SIZE];

public:

  sbuf()
  {
    memset(buf, 0, bytes());
  }

  operator T * () { return buf; }
  u32 size() const { return SIZE; }
  u32 bytes() const { return sizeof(T) * SIZE; }
};

/// ヒープ上のバッファを自分のスコープの間だけ管理するバッファクラス。
template <typename T, u32 SIZE> class hbuf
{
private:
  T *buf;

public:

  hbuf() : buf(new T [SIZE])
  {
    memset(buf, 0, bytes());
  }

  ~hbuf()
  {
    delete [] buf;
  }

  operator T * () { return buf; }
  u32 size() const { return SIZE; }
  u32 bytes() const { return sizeof(T) * SIZE; }
};

#endif // !defined(INCLUDED_SOFTGATE_BUFFERS)
